﻿// Procedure Loader Hide
#pragma TextEncoding = "UTF-8"
#pragma rtGlobals=3		// Use modern global access method and strict wave access.
#pragma hide=1

// uncomment to debug
//#define DEBUG

// ***
// FUNCTIONS

// draw tab22 - threshold
Function disp_Tab22Draw(pwidth,pheight, ptabpos)
	variable pwidth, pheight, ptabpos

	variable tvoffset, dtvoffset = 30
	
	string qu = "\""
	string tmodes = qu + "Manual;Iterative;Bimodal;Adaptive;Fuzzy;Fuzzy+;Cluster;Otsu;Range;" + qu
	
	tvoffset = ptabpos + dtvoffset
	
	PopupMenu popupThresOnPlane_tab22,pos={pwidth-110,tvoffset},size={100,23},title="", proc=X_PopMenuProc
	PopupMenu popupThresOnPlane_tab22,mode=1,value="This Layer;Each Layer;All Layers;",disable=1
	
	tvoffset += 0.8*dtvoffset
	
	PopupMenu popupThresMethod_tab22,pos={20,tvoffset},size={124,25},title="Method"
	PopupMenu popupThresMethod_tab22,mode=1,popvalue="Manual",value=#tmodes, disable=1, proc=X_PopMenuProc

	SetVariable setvarThresLevel_tab22,pos={160,tvoffset},size={100,25},title="Level",format="%6.3g"
	SetVariable setvarThresLevel_tab22,limits={0,inf,1},value=_NUM:0, disable=1, proc=X_SetVarProc
	SetVariable setvarThresRange_tab22,pos={270,tvoffset},size={90,25},title="Range",format="%6.3g"
	SetVariable setvarThresRange_tab22,limits={0,inf,1},value=_NUM:0, disable=1, proc=X_SetVarProc
	
	Checkbox checkAutoThreshold_tab22,pos={pwidth-30,tvoffset},size={25,25},title="!"
	Checkbox checkAutoThreshold_tab22,value=0,proc=X_CheckProc,disable=1
	
	tvoffset += dtvoffset
	
	PopupMenu popupThRoI_tab22,pos={20,tvoffset},size={120,23},title="RoI", proc=X_PopMenuProc
	PopupMenu popupThRoI_tab22,mode=1,popvalue="All",value=f_ThRoIs(),disable=1
	PopupMenu popupThRoI_tab22,help={"Choose a region of interest to optimize the threshold calculations."}

	PopupMenu popupThMaskVal_tab22,pos={180,tvoffset},size={80,23},title="Mask Value @"
	PopupMenu popupThMaskVal_tab22,mode=1,popvalue="0",value="0;-;NaN;",disable=1
	PopupMenu popupThMaskVal_tab22,help={"Set the value for the regions outside\rthe threshold as zero, unchanged, or NaN."}
	
	tvoffset += 2.8*dtvoffset

	Button buttonFillThreshold_tab22,pos={pwidth-285,tvoffset-5},size={75,25},proc=X_ButtonProc,title="Fill",disable=1	

	Button buttonShowThStats_tab22,pos={pwidth-200,tvoffset-5},size={90,25},proc=X_ButtonProc,title="Show Stats",disable=1

	Button buttonDoThreshold_tab22,pos={pwidth-85,tvoffset-5},size={75,25},proc=X_ButtonProc,title="Apply"
	Button buttonDoThreshold_tab22,disable=1

	return 0
end

// update tab Threshold
Function disp_updateTab22()
	
	DFREF pf=$k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile

	variable method, thlevel, tabsent=1, fwhite=0
	string thlevels = ""
	
	// Apply Threshold
	
	if (f_ThresholdExists(specific=1)<0)
		Checkbox checkAutoThreshold_tab22, win=$k_fullPanel, disable=0, value=0
		Button buttonShowThStats_tab22, win=$k_fullPanel, disable=1
	else
		Checkbox checkAutoThreshold_tab22, win=$k_fullPanel, disable=0
		Button buttonShowThStats_tab22, win=$k_fullPanel, disable=0
	endif
	ControlInfo/W=$k_fullpanel checkAutoThreshold_tab22
	if (v_value)
		Button buttondoThreshold_tab22, win=$k_fullpanel, title="Re-Apply"
	else
		Button buttondoThreshold_tab22, win=$k_fullpanel, title="Apply"
	endif
	
	if (f_IsThreshold())
		Button buttonFillThreshold_tab22, win=$k_fullpanel, disable=0
		Button buttondoThreshold_tab22, win=$k_fullpanel, disable=2
		Checkbox checkAutoThreshold_tab22, win=$k_fullPanel, disable=2
	else
		Button buttonFillThreshold_tab22, win=$k_fullpanel, disable=2
		Button buttondoThreshold_tab22, win=$k_fullpanel, disable=0
		Checkbox checkAutoThreshold_tab22, win=$k_fullPanel, disable=0
	endif
	
	if (!f_HasMQ())
		PopupMenu popupThRoI_tab22, win=$k_fullPanel, mode=1
	endif
	
	ControlInfo/W=$k_fullPanel popupThRoI_tab22
	PopupMenu popupThMaskVal_tab22, win=$k_fullPanel, disable=(2*(v_value==1))
	
	ControlInfo/W=$k_fullpanel popupThresMethod_tab22
	method = v_value
	switch(method)
		case 1:	// manual
		case 9:  // range
			thlevel = xcsr(A,k_histGraphs)
			break
		default:	// all others
			if (f_isThreshold())
				thlevels = "root:" + cwdfolder + ":" + cwfile[4,inf] + "levels"
			else
				thlevels = "root:" + cwdfolder + ":" + cwfile[4,inf] + "_thlevels"
			endif
			wave/Z thl = $thlevels
			if (waveexists(thl))
				if (f_isStack())
					tabsent = 0
					thlevel = thl[f_PlaneNumber()][0]
					fwhite = thl[f_PlaneNumber()][1]
				else
					thlevel = thl[0][0]
					fwhite = thl[0][1]
				endif
			else
				thlevel = xcsr(A,k_histGraphs)
			endif
			if (method != 1)
				thlevels = TraceNameList(k_histGraphs,";",1)
				thlevels = StringFromList(1,SortList(thlevels))
				Cursor/W=$k_histGraphs/S=0 A, $thlevels, thlevel
			else
				thlevel = xcsr(A,k_histGraphs)
			endif
			break
	endswitch
	
	SetVariable setvarThresLevel_tab22, win=$k_fullPanel, disable=(2*((method!=1) && (method!=9))), value=_NUM:thlevel
	SetVariable setvarThresRange_tab22, win=$k_FullPanel, disable=(2*(method!=9))
	if (f_IsStack())
		if (!f_StackOKtoThreshold())
			PopupMenu popupThresOnPlane_tab22, win=$k_fullPanel, value="This Layer;Each Layer;(-All Layers;",disable=0
		else
			PopupMenu popupThresOnPlane_tab22, win=$k_fullPanel, value="This Layer;Each Layer;All Layers;",disable=0
		endif
	else
		PopupMenu popupThresOnPlane_tab22, win=$k_fullPanel, disable=1
	endif
	
#ifdef DEBUG
	print "reset cursor due to threshold change ", thlevels, thlevel
#endif
	
	return 0
end

// start a threshold calculation
Function T22_StartThreshold()

	STRUCT S_ThresholdParams thp
	Sf_GetThresholdParams(thp)

	variable ic, nplanes
	
	if (thp.method == 9 && thp.range == 0)
		thp.method = 1
	endif
		
	if (f_IsStack())
		switch(thp.oTP)
			case 1:		// this plane only
				T22_DoThreshold(thp.method,thp.level,range=thp.range,plane=f_PlaneNumber(),tRoI=thp.roi,soRoI=thp.stZ)
				break
			case 2:		// each plane
				if (thp.method == 1)
					T22_DoThreshold(thp.method,thp.level,range=thp.range,tRoI=thp.roi,soRoI=thp.stZ)
				else
					nplanes = f_NImagesInStack()
					for (ic=0;ic<nplanes;ic+=1)
						T22_DoThreshold(thp.method,thp.level,range=thp.range,plane=ic,tRoI=thp.roi,soRoI=thp.stZ)
					endfor
				endif
				break
			case 3:		// all planes
				T22_DoThreshold(thp.method,thp.level,range=thp.range,tRoI=thp.roi,soRoI=thp.stZ)
				break
		endswitch
	else
		T22_DoThreshold(thp.method,thp.level,range=thp.range,tRoI=thp.roi,soRoI=thp.stZ)
	endif

	return 0
end

// do threshold of image
// method -- how
// level -- manual level
// range -- extent
// tRoI -- within RoI only
// soRoI -- set the other part of the RoI to zero
// plane -- only on this specific plane
Function T22_DoThreshold(method, level, [range, tRoI, soRoI, plane])
	variable method, level, range, tRoI, soRoI, plane

	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile

	string wdf = "root:" + cwdfolder
	string sfile, wfile, lstr
	
	variable nimgs, thexists = 0, onpl = 0, isstack = 0
	variable npts, ic, nplanes

	if (f_IsFill() > 0)
		return 0
	endif
		
	// work within the data folder to store threshold files
	DFREF cdf = GetDataFolderDFR()	
	SetDataFolder wdf

	// set existence of threshold
	if (f_isThreshold()>0)
		wfile = cwfile
		sfile = ReplaceString("_th",cwfile,"")
		thexists = 1
	else
		sfile = cwfile
		if (f_ThresholdExists(specific=1)<0)
			wfile = sfile + "_th"
			duplicate $cwfile $wfile
			wave/SDFR=$wdf tw = $wfile
			tw = 0
		else
			wfile = (StringFromList(f_ThresholdExists(),f_LoimgF(all=1,full=1)))
			wave/SDFR=$wdf tw = $wfile
		endif
	endif
	
	// handle a stack
	if (f_IsStack())
		nimgs = f_NImagesInStack()
		isStack = 1
	else
		nimgs = 1
		isStack = 0
	endif
	
	// handle RoI
	if (ParamIsDefault(tRoI))
		tRoI = 0
	endif
	if (ParamIsDefault(soRoI))
		soRoI = 1
	endif	

	// wave to store setting and results
	lstr = sfile[4,inf] + "_thlevels"	
	wave/Z/SDFR=$wdf tlevels = $lstr
	if (!WaveExists(tlevels))
		make/N=(nimgs,3) $lstr = NaN
	endif
	
	// set the source files (source image, threshold image, threshold level, white fraction, fill fraction)
	wave/SDFR=$wdf simage = $sfile
	wave/SDFR=$wdf tw = $wfile
	wave/SDFR=$wdf tlevels = $lstr
	
	// assure that the threshold levels wave has the right number of dimensions
	Redimension/N=(-1,3) tlevels
	
	// do individual planes or all of stacks?
	if (isStack)
		if (ParamIsDefault(plane))
			plane = -1	// all
			onpl = 0
		else
			onpl = 1
		endif
	else
		plane = -1		// all (entire single image)
	endif

#ifdef DEBUG
	print "doing threshold: ", sfile, wfile, lstr, plane, level, method
#endif

	// generate mask
	STRUCT S_MarqueeCoordinates mc
	if (tRoI != 0)
		Sf_GetMQCoordinates(mc)
		wave RoIMask = generate_RoIMask(simage,mc,tRoI,1)
	endif
	
	if (method == 8)
		Make/N=2/D/FREE thrange = {level, level+range}
	endif
	
	switch(method)
		case 0:		//manual
			if (tRoI == 0)
				ImageThreshold/P=(plane)/M=0/T=(level)/Q simage
			else
				ImageThreshold/P=(plane)/M=0/T=(level)/Q/R={RoIMask,soRoI} simage
			endif
			v_threshold = level
			break
		case 3:		// adaptive
			if (tRoI == 0)
				ImageThreshold/P=(plane)/M=3/Q simage
			else
				ImageThreshold/P=(plane)/M=3/Q/R={RoIMask,soRoI} simage
			endif
			break
		case 1:		// iterative
		case 2:		// bimodal
		case 4:		// fuzzy
		case 5:		// fuzzy+
		case 6:		// cluster
		case 7:		// Otsu
			if (tRoI == 0)
				ImageThreshold/P=(plane)/M=(method)/Q simage
			else
				ImageThreshold/P=(plane)/M=(method)/Q/R={RoIMask,soRoI} simage
			endif
			break
		case 8:		// range
			if (tRoI == 0)
				ImageThreshold/P=(plane)/M=0/W=thrange/Q simage
			else
				ImageThreshold/P=(plane)/M=0/W=thrange/Q/R={RoIMask,soRoI} simage
			endif
			v_threshold = level
			break
	endswitch
	
	wave M_ImageThresh

	// store values
	if (isstack)
		// a stack
		if (onpl)
			tlevels[plane][0] = v_threshold
			tw[][][plane] = M_ImageThresh[p][q]
			WaveStats/Q/M=1 M_ImageThresh
			tlevels[plane][1] = V_avg/V_max
			tlevels[plane][2] = NaN
		else
			tlevels[][0] = v_threshold
			MatrixOP/O tw = M_ImageThresh
			make/N=(nimgs)/FREE t_thlevels=0
			MultiThread t_thlevels = T2_calcLayerFrac(tw,p)
			tlevels[][1] = t_thlevels[p]/255
			tlevels[][2] = NaN
		endif
	else
		// not a stack
		tlevels[0][0] = v_threshold
		duplicate/O M_ImageThresh tw
		WaveStats/Q/M=1 tw
		tlevels[0][1] = V_avg/255
		tlevels[0][2] = NaN
	endif

#ifndef DEBUG
	killwaves/Z M_ImageThresh
#endif
	
	SetDataFolder pf
	
	make/N=4/T/O ptxt={"Applied Threshold","Plane","Method","Threshold Value","On Plane Only"}
	make/N=3/D/O pvals={plane,method,v_threshold,onpl}

	SetDataFolder cdf
	
	return 0
end

// fill threshold
Function T22_FillThreshold()

	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile

	string wdf = "root:" + cwdfolder
	string thfile, lstr, tffile
	variable useMQ

	STRUCT S_ThresholdParams thp
	Sf_GetThresholdParams(thp)
	useMQ = thp.roi

	if (!f_ThresholdExists())
		return 0
	endif
	
	variable isStack = 0, cplane = 0, tplanes, exit = 0
	
	// set existence of threshold
	if (f_isThreshold())
		thfile = cwfile
		lstr = cwfile[4,strlen(cwfile)-4] + "_thlevels"
	else
		thfile = StringFromList(f_ThresholdExists(),f_LoimgF(all=1,full=1))
		lstr = cwfile[4,inf] + "_thlevels"
	endif
	
	tffile = cwfile + "_fl"
	
	wave/SDFR=$wdf tsimg = $thfile
	wave/SDFR=$wdf thwave = $lstr
	
	if (f_isStack())
		isStack = 1
		tplanes = DimSize(tsimg,2)
	endif
	
	DFREF cdf = GetDataFolderDFR()	
	SetDataFolder wdf

	wave/Z tfill = $tffile
	if (!WaveExists(tfill))
		duplicate/O tsimg $tffile
	endif
	wave tfill = $tffile
		
	NewDataFolder/O/S tmp
	
	do
		if (isStack)
			if (thp.onStack == 1)
				cplane = f_PlaneNumber()
				exit = 1
			endif
			MatrixOP/FREE tfimg = tsimg[][][cplane]
		else
			duplicate/FREE tsimg tfimg
			exit = 1
		endif
		
		variable a, ic = 1
		
		if (useMQ > 1)
			GetMarquee/W=$k_imgDisplay/Z left, top
			a = 0.9*abs(v_right - v_left)*abs(v_bottom - v_top)
		else
			a = 0.9*DimSize(tfimg,0)*DimSize(tfimg,1)
		endif
		
		if (f_ImageBitDepth() > 8)
			Redimension/B/U tfimg
		endif
		ImageTransform/O invert tfimg
		for(ic=2;ic<10;ic+=1)
			ImageAnalyzeParticles/Q/A=(a)/FILL/M=3 stats tfimg
			if (v_numparticles == 1)
				break
			else
				a *= 1 - 0.1*ic
			endif
		endfor
			
		wave M_particle
		
		if (v_numparticles != 0)
			//ImageTransform/O invert M_Particle
			M_particle = M_Particle < 63 ? 255 : 0
			if (isStack)
				//ImageTransform/P=(cplane)/D=M_Particle setPlane tsimg
				ImageTransform/P=(cplane)/D=M_Particle setPlane tfill
				WaveStats/Q/M=1 M_Particle
				thwave[cplane][2] = V_avg/255
			else
				//tsimg = M_Particle
				tfill = M_Particle
				thwave[0][2] = NaN
				WaveStats/Q/M=1 M_Particle
				thwave[0][2] = V_avg/255
			endif
		else
			DoAlert/T="Fill Threshold", 0, "A continguous boundary was not found in the threshold. Filling was therefore unsuccessful."
			if (f_isStack())
				thwave[cplane][2] = NaN
			else
				thwave[0][2] = NaN
			endif
		endif
		if (isStack)
			cplane += 1
			if (cplane == tplanes)
				exit = 1
			endif
		endif
	while(!exit)
	
	// kill temporary
	
	SetDataFolder wdf
	KillDataFolder/Z tmp
	SetDataFolder cdf
	
	return 0
end

// get value for layer
ThreadSafe Function T2_calcLayerFrac(ww,nl)
	wave ww
	variable nl
	
	MatrixOP/FREE val = mean(layer(ww,nl))
	return val[0]
end

// show fWhite
Function T2_showfWhite()

	KillWindow/Z fWhite
	
	DFREF pf=$k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile
	
	string thlevels
	variable npts
	
	if (f_isThreshold())
		thlevels = "root:" + cwdfolder + ":" + cwfile[4,inf] + "levels"
	else
		thlevels = "root:" + cwdfolder + ":" + cwfile[4,inf] + "_thlevels"
	endif
	wave/Z thl = $thlevels
	npts = DimSize(thl,0)
	DFREF cdf = GetDataFolderDFR()
	SetDataFolder pf
	Make/O/N=(npts)/D thfWhite
	thfWhite = thl[p][1]
	Display/N=fWhite thfWhite as "Fraction White"	
	ModifyGraph mode=3,marker=8,msize=2,mrkThick=1,rgb=(0,0,0)
	SetAxis/N=1 left 0,*
	SetDataFolder cdf
	
	return 0
end

// show the threshold image in the split window
Function T22_ShowThreshold()
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwfile
	disp_ShowInSplit(cwfile[4,inf]+"_th")
	return 0
end

// show the fill image in the split window
Function T22_ShowFill()
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwfile
	disp_ShowInSplit(cwfile[4,inf]+"_fl")
	return 0
end

// show the statistics for the threshold analysis
Function T22_ShowThesholdStats()

	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile

	string wdf = "root:" + cwdfolder
	string thswave
	// threshold wave resolves to its own source
	thswave = ReplaceString("_th",cwfile,"") + "_thlevels"
	thswave = thswave[4,inf]
	
	wave/SDFR=$wdf/Z thwave = $thswave	
	if (!WaveExists(thwave))
		return 0
	endif
	
	KillWindow/Z $k_TableThresholdStats
	Edit/N=$k_TAbleThresholdStats thwave
	
	return 0
end
